dofile(LockOn_Options.common_script_path.."elements_defs.lua")
dofile(LockOn_Options.script_path.."Gunsight_K14/device/K14_param.lua")

SetScale(MILLYRADIANS)

HUD_DEFAULT_LEVEL = 9
HUD_NOCLIP_LEVEL = HUD_DEFAULT_LEVEL - 1

if K14_use_mirror_adjusting then
	ZSL = 0
else
	ZSL	= -60.0
end

use_mipfilter	= true

function AddHUDK14TexElement(name, vertices, tex_params, controllers, init_pos, init_rot, parent, level)
local 	element				= CreateElement "ceTexPoly"
	element.indices			= default_box_indices
	element.material		= "INDICATION_K14"
	
	element.name			= name
	element.vertices		= vertices
	element.tex_params 		= tex_params 
	
	if controllers ~= nil then
		element.controllers	= controllers
	end
	
	element.init_pos		= init_pos
	element.init_rot		= init_rot

	element.isdraw			= false	
	if parent ~= nil then
		element.parent_element	= parent
		element.isdraw			= true
	end
	
	element.h_clip_relation	= h_clip_relations.COMPARE
	element.level			= level
	
	element.additive_alpha	= true
	element.collimated		= true

	
	element.use_mipfilter	= use_mipfilter
		
	Add(element)

	return element

end